#!/bin/bash
VALIDMETRICWASHERS="M1_6,M2,M2_5,M2_6,M3,M3_5,M4,M5,M6,M7,M8,M10,M12,M14,M16,M18,M20,M22,M24,M27,M30,M33,M36,M39,M42,M45,M48,M52,M56"

usage() {
    echo Usage: $1
    cat <<EOU
    -m metric washer size (e.g. "M4").
    -s Size, given as [hole_size,washer_diameter,thickness] in mm, for example [3,7,0.6]
EOU
}

#
# Main Line
#

OPTSTR="m:s:"

while getopts ${OPTSTR} ARG
do
    case ${ARG} in
	m) MSIZE=${OPTARG} ;;
	s) SIZEVEC=${OPTARG} ;;
	*) usage $0 ${OPTSTR}; exit 1 ;;
    esac
done

if [ ${MSIZE:-NOTHING} != "NOTHING" ]
then
    if ! echo ${VALIDMETRICWASHERS} | grep $MSIZE > /dev/null
    then
	echo Oops. Valid washer sizes are ${VALIDMETRICWASHERS}.
	usage $OPTSTR
	exit 1
    fi
fi

if [ ${SIZEVEC:-NOTHING} != "NOTHING" ]
   then
       if ! echo ${SIZEVEC} | grep '^\[[0-9]\+,[0-9]\+,[0-9]\+\]'
       then
	   echo Oops. Proper size vector is [hole size,diameter,thickness].
	   usage ${OPTSTR}
	   exit 1
       fi
fi

if [ ${MSIZE:-NOTHING} != NOTHING ]
then
    THESIZE=${MSIZE}
else
    THESIZE=${SIZEVEC}
fi

				     
  
set -x
openscad -Dwasher_size=$THESIZE -o washer.stl washer.scad
